using System;
using Borland.Eco.Handles;
using Borland.Eco.Web;

namespace SimpleEcoWebDemo
{

	public abstract class EcoSpaceProvider
	{

		// ToDo: Configure the strategy for the provider by changing the constant

		private const EcoSpaceStrategyHandler.SessionStateMode sessionStateMode = EcoSpaceStrategyHandler.SessionStateMode.Always;

		private static EcoSpaceStrategyHandler GetStrategyhandler()
		{
			return new EcoSpaceStrategyHandler(sessionStateMode, typeof(SimpleEcoWebDemoEcoSpace));
		}

		public static SimpleEcoWebDemoEcoSpace GetEcoSpace()
		{
			return GetStrategyhandler().GetEcoSpace() as SimpleEcoWebDemoEcoSpace;
		}

		public static void ReturnEcoSpace(EcoSpace ecoSpace)
		{
			GetStrategyhandler().ReturnEcoSpace(ecoSpace);
		}

		public void ClearSessionState()
		{
            GetStrategyhandler().ClearSessionState();
		}
	}
}
